@addField(PreventionSystem)
let maxtacSpawned: Bool;

@addField(PreventionDelayedSpawnRequest)
let isVehicleSpawn: Bool; //Used for delayed vehicle spawns


@replaceMethod(PreventionSystem)
  private final func OnDelayedSpawnRequest(evt: ref<PreventionDelayedSpawnRequest>) -> Void {
	if evt.isVehicleSpawn {
		this.SpawnPoliceVehicle(evt.heatStage);
	}
	else{
    this.m_policemenSpawnDelayID = GetInvalidDelayID();
		this.SpawnPolice(evt.heatStage);
	};
  }


@addMethod(PreventionSystem)
  private final func SpawnPoliceVehicleWithDelay(heatStage: EPreventionHeatStage, delay: Float) -> Void {
    let evt: ref<PreventionDelayedSpawnRequest>;
  //  this.CancelSpawnDelay();
    evt = new PreventionDelayedSpawnRequest();
    evt.heatStage = heatStage;
	evt.isVehicleSpawn = true;
    //this.m_policemenSpawnDelayID = 
	GameInstance.GetDelaySystem(this.GetGame()).DelayScriptableSystemRequest(n"PreventionSystem", evt, delay);
  }
  
  
  
//Improve the spawning when in a vehicle
@replaceMethod(PreventionSystem)
  private final func GetFindSpawnPointsOriginsData(out spawnOriginsData: array<SpawnOriginData>) -> Void {
    let currentOriginData: SpawnOriginData;
    let distanceToCheck: Float;
    let i: Int32;
    let offsetDist: Float;
    let pointData: ref<PointData>;
    let singleSortedResult: HandleWithValue;
    let sortedResults: array<HandleWithValue>;
    let vehSpeed: Float;
    let vehicle: wref<VehicleObject>;
    let viewerPos: Vector4;
    let playerForward: Vector4 = this.m_player.GetWorldForward();
    let playrPos: Vector4 = this.m_player.GetWorldPosition();
	let spawnMin: Float = TweakDBInterface.GetFloat(t"VC.InVehicleSpawnMin", 20);
	let spawnMax: Float = TweakDBInterface.GetFloat(t"VC.InVehicleSpawnMax", 60);
	let spawnDiv: Float = TweakDBInterface.GetFloat(t"VC.InVehicleSpawnDiv", 30);
    if VehicleComponent.GetVehicle(this.m_player.GetGame(), this.m_player, vehicle) {
      vehSpeed = vehicle.GetBlackboard().GetFloat(GetAllBlackboardDefs().Vehicle.SpeedValue);
      if vehSpeed > 20.0 {
        offsetDist = LerpF(vehSpeed/spawnDiv, spawnMin, spawnMax, true); //This line edited
        currentOriginData.position = playrPos + offsetDist * vehicle.GetWorldForward();
		
        currentOriginData.direction = playerForward * -1.00;
        currentOriginData.playerPosition = playrPos + offsetDist * vehicle.GetWorldForward(); //This line edited
      } else {
        currentOriginData.position = playrPos;
        currentOriginData.direction = playerForward;
        currentOriginData.playerPosition = playrPos;
      };
      ArrayPush(spawnOriginsData, currentOriginData);
    } else {
      currentOriginData.position = playrPos;
      currentOriginData.direction = playerForward;
      currentOriginData.playerPosition = playrPos;
      ArrayPush(spawnOriginsData, currentOriginData);
      i = 0;
      while i < ArraySize(this.m_viewers) {
        viewerPos = this.m_viewers[i].GetWorldPosition();
        distanceToCheck = Vector4.Distance(playrPos, viewerPos);
        if distanceToCheck <= this.GetSpawnOriginMaxDistance() {
          pointData = new PointData();
          pointData.position = viewerPos;
          pointData.direction = playerForward;
          singleSortedResult.value = distanceToCheck;
          singleSortedResult.handle = pointData;
          ArrayPush(sortedResults, singleSortedResult);
        };
        i += 1;
      };
      if !Vector4.IsZero(this.m_lastCrimePoint) && NotEquals(this.m_lastCrimePoint, playrPos) {
        distanceToCheck = Vector4.Distance(playrPos, this.m_lastCrimePoint);
        if distanceToCheck <= this.GetSpawnOriginMaxDistance() {
          pointData = new PointData();
          pointData.position = this.m_lastCrimePoint;
          pointData.direction = playerForward;
          singleSortedResult.value = distanceToCheck;
          singleSortedResult.handle = pointData;
          ArrayPush(sortedResults, singleSortedResult);
        };
      };
      if !Vector4.IsZero(this.m_lastBodyPosition) && NotEquals(this.m_lastBodyPosition, this.m_lastCrimePoint) {
        distanceToCheck = Vector4.Distance(playrPos, this.m_lastBodyPosition);
        if distanceToCheck <= this.GetSpawnOriginMaxDistance() {
          pointData = new PointData();
          pointData.position = this.m_lastBodyPosition;
          pointData.direction = playerForward;
          singleSortedResult.value = distanceToCheck;
          singleSortedResult.handle = pointData;
          ArrayPush(sortedResults, singleSortedResult);
        };
      };
      if ArraySize(sortedResults) > 0 {
        SortHandleWithValueArray(sortedResults);
        i = 0;
        while i < ArraySize(sortedResults) {
          pointData = sortedResults[i].handle as PointData;
          if IsDefined(pointData) {
            currentOriginData.position = pointData.position;
            currentOriginData.direction = pointData.direction;
            currentOriginData.playerPosition = playrPos;
            ArrayPush(spawnOriginsData, currentOriginData);
          };
          i += 1;
        };
      };
    };
  }
  

 
@replaceMethod(PreventionSystem)
  private final func MountVehicle(unit: wref<ScriptedPuppet>, vehicle: wref<VehicleObject>) -> Bool {
    let evt: ref<MountAIEvent>;
    let mountData: ref<MountEventData>;
    let slotName: CName;
    if !IsDefined(unit) || !IsDefined(vehicle) {
      return false;
    };
	
    if !this.IsVehicleValid(vehicle, slotName) {

      return false;
    };
	
	//Enable the police sirens
	if this.IsChasingPlayer() {
		  vehicle.ToggleSiren(true);
	};
    mountData = new MountEventData();
    mountData.slotName = slotName;
    mountData.mountParentEntityId = vehicle.GetEntityID();
    mountData.isInstant = true;
    mountData.ignoreHLS = true;
    evt = new MountAIEvent();
    evt.name = n"Mount";
    evt.data = mountData;
    unit.QueueEvent(evt);
    return true;
  }
  
  //Adjust spawning
@replaceMethod(PreventionSystem)
  private final func SpawnPoliceVehicle(heatStage: EPreventionHeatStage) -> Void {
    let spawnPosition: Vector4;
    let spawnTransform: WorldTransform;
    let vehicleID: TweakDBID;
    let pointResults: NavigationFindPointResult;

    if !this.GetVehicleIDFromHeatStage(heatStage, vehicleID) {
      return;
    };
	
    let fallbackSpawnPoints: array<Vector4>;
    let i: Int32;
    let spawnOriginsData: array<SpawnOriginData>;
    let spawnPoints: array<Vector4>;
	let vehicleIDArr: array<TweakDBID>;
	ArrayPush(vehicleIDArr, vehicleID);
    if !IsDefined(this.m_player) {
      return;
    };
	  this.GetFindSpawnPointsOriginsData(spawnOriginsData);
	  i = 0;
	  while i < ArraySize(spawnOriginsData) {
		if GameInstance.GetNavigationSystem(this.GetGameInstance()).FindPursuitPointsRange(spawnOriginsData[i].playerPosition, spawnOriginsData[i].position, spawnOriginsData[i].direction, 60, 100, 1, false, NavGenAgentSize.Human, spawnPoints, fallbackSpawnPoints) {
		
			//Some bigger vehicles spawn in the ground, so raise them up
			if ArraySize(spawnPoints) >0{
				//Use the original vehicle spawning mechanism to make sure it's on the ground
				pointResults = GameInstance.GetAINavigationSystem(this.GetGameInstance()).FindPointInSphereForCharacter(spawnPoints[0], 8, this.m_player);
				spawnPoints[0] = pointResults.point;

				this.SpawnUnits(spawnPoints, vehicleIDArr, Cast(EnumInt(heatStage)), 1);

			}
			else{
				//Use the original vehicle spawning mechanism to make sure it's on the ground
				pointResults = GameInstance.GetAINavigationSystem(this.GetGameInstance()).FindPointInSphereForCharacter(fallbackSpawnPoints[0], 8, this.m_player);
				fallbackSpawnPoints[0] = pointResults.point;

				this.SpawnUnits(fallbackSpawnPoints, vehicleIDArr, Cast(EnumInt(heatStage)), 1);
			};
			break;
		};
		i = i +1;
	};

	  
  }


  
@replaceMethod(PreventionSystem)
  private final func GetVehicleIDFromHeatStage(heatStage: EPreventionHeatStage, out vehicleID: TweakDBID) -> Bool {
    let heatData: wref<PreventionHeatData_Record>;
    if IsDefined(this.m_preventionPreset) {
      switch heatStage {
        case EPreventionHeatStage.Heat_0:
          return false;
        case EPreventionHeatStage.Heat_1:
          heatData = this.m_preventionPreset.Heat1();
          break;
        case EPreventionHeatStage.Heat_2:
          heatData = this.m_preventionPreset.Heat2();
          break;
        case EPreventionHeatStage.Heat_3:
          heatData = this.m_preventionPreset.Heat3();
          break;
        case EPreventionHeatStage.Heat_4:
          heatData = this.m_preventionPreset.Heat4();
          break;
        default:
          return false;
      };

      if IsDefined(heatData) && IsDefined(heatData.VehicleRecord()) {
        vehicleID = heatData.VehicleRecord().GetID();
      };
    };
    return TDBID.IsValid(vehicleID);
  }


@replaceMethod(PreventionSystem)
   private final func GetSpawnDataFromHeatStage(heatStage: EPreventionHeatStage, out characterRecords: array<TweakDBID>, out spawnRange: Vector2, out unitsCount: Uint32, out spawnInterval: Float, out hasRecon: Bool) -> Bool {
    let characterRecord: TweakDBID;
    let characterRecordPool: array<wref<PreventionUnitPoolData_Record>>;
    let heatData: wref<PreventionHeatData_Record>;
    let i: Int32;
    ArrayClear(characterRecords);
    if IsDefined(this.m_preventionPreset) {
	
      if !IsDefined(heatData) {
        switch heatStage {
          case EPreventionHeatStage.Heat_0:
            return false;
          case EPreventionHeatStage.Heat_1:
            heatData = this.m_preventionPreset.Heat1();
            break;
          case EPreventionHeatStage.Heat_2:
            heatData = this.m_preventionPreset.Heat2();
            break;
          case EPreventionHeatStage.Heat_3:
            heatData = this.m_preventionPreset.Heat3();
            break;
          case EPreventionHeatStage.Heat_4:
            heatData = this.m_preventionPreset.Heat4();
            break;
          default:
            return false;
        };
      } else {
        hasRecon = true;
      };
      if IsDefined(heatData) && heatData.GetUnitRecordsPoolCount() > 0 {
        heatData.UnitRecordsPool(characterRecordPool);
        unitsCount = Cast(heatData.UnitsCount());
        spawnRange = heatData.SpawnRange();
        spawnInterval = MaxF(heatData.SpawnInterval(), 0.00);
        i = 0;
        while i < Cast<Int32>(unitsCount) {
          if this.GetCharacterRecordFromPool(characterRecordPool, characterRecord) {
            ArrayPush(characterRecords, characterRecord);
          } else {
            break;
          };
          i += 1;
        };
        if ArraySize(characterRecords) > 0 {
          return true;
        };
      };
    };
    switch heatStage {
      case EPreventionHeatStage.Heat_0:
        return false;
      case EPreventionHeatStage.Heat_1:
        ArrayPush(characterRecords, this.m_failsafePoliceRecordT1);
        unitsCount = 2u;
        spawnRange.Y = 45.00;
        spawnRange.Y = 65.00;
        break;
      case EPreventionHeatStage.Heat_2:
        ArrayPush(characterRecords, this.m_failsafePoliceRecordT2);
        unitsCount = 2u;
        spawnRange.Y = 45.00;
        spawnRange.Y = 65.00;
        break;
      case EPreventionHeatStage.Heat_4:
      case EPreventionHeatStage.Heat_3:
        ArrayPush(characterRecords, this.m_failsafePoliceRecordT3);
        unitsCount = 2u;
        spawnRange.Y = 45.00;
        spawnRange.Y = 65.00;
        break;
      default:
    };
    if ArraySize(characterRecords) > 0 {
      return true;
    };
    return false;
  }

@replaceMethod(PreventionSystem)
  protected final func OnPreventionSecurityAreaRequest(request: ref<PreventionSecurityAreaRequest>) -> Void {
    if request.playerIsIn {
      if !ArrayContains(this.m_playerIsInSecurityArea, request.areaID) {
	  
		//Make it so we can spawn when in mission zones by just removing the thing that says we're in a mission zone
        //ArrayPush(this.m_playerIsInSecurityArea, request.areaID);		
      };
    } else {
      if ArrayContains(this.m_playerIsInSecurityArea, request.areaID) {
        ArrayRemove(this.m_playerIsInSecurityArea, request.areaID);
      };
    };
    this.ReevaluateSecurityAreaReset();
    if !IsFinal() {
      this.RefreshDebugSecAreaInfo();
    };
  }

@replaceMethod(PreventionSystem)
  private final func SpawnUnits(spawnPoints: array<Vector4>, characterRecords: array<TweakDBID>, heatStage: Uint32, spawnInterval: Float) -> Bool {
    let currentRecordIdx: Int32;
    let i: Int32;
    let lastRecordIdx: Int32;
    let spawnTransform: WorldTransform;
    if ArraySize(spawnPoints) > 0 {
      lastRecordIdx = ArraySize(characterRecords) - 1;
      i = 0;
      while i < ArraySize(spawnPoints) {
        WorldTransform.SetPosition(spawnTransform, spawnPoints[i]);
        WorldTransform.SetOrientationFromDir(spawnTransform, Vector4.Normalize2D(this.m_player.GetWorldPosition() - spawnPoints[i]));
        PreventionSystem.DelayedSpawnUnitRequest(this.GetGame(), characterRecords[currentRecordIdx], heatStage, spawnTransform, Cast<Float>(i + 1) * spawnInterval);
        if currentRecordIdx < lastRecordIdx {
          currentRecordIdx += 1;
        }
		else{ //Set the records to start iterating from 0 again as opposed to just spawning the last unit each time
			currentRecordIdx=0;
		};
        i += 1;
      };
      return true;
    };
    return false;
  }



//Disable default recon mechanics
@wrapMethod(PreventionSystem)
  private final func SpawnPolice(heatStage: EPreventionHeatStage) -> Void {
      this.m_reconDeployed = true;

	  wrappedMethod(heatStage);
  }




  //Always spawn a vehicle for these bad boys
@replaceMethod(PreventionSystem)
  private final func SpawnPipeline(heatStage: EPreventionHeatStage, opt delay: Float) -> Void {
    if !this.CanPreventionReactToInput() {
      return ;
	 
    };
	if this.maxtacSpawned {
		return;
	};
	/* Let the spawning continue even when in mission zones
    if ArraySize(this.m_playerIsInSecurityArea) > 0 {
      return ;
    };*/
    if Equals(heatStage, EPreventionHeatStage.Heat_0) {
      return ;
    };
    this.CancelSpawnDelay();
    this.UpdateVehicles();
	
	let vehicleCount: Int32;
    let heatData: wref<PreventionHeatData_Record>;
	switch heatStage {
        case EPreventionHeatStage.Heat_1:
          heatData = this.m_preventionPreset.Heat1();
          break;
        case EPreventionHeatStage.Heat_2:
          heatData = this.m_preventionPreset.Heat2();
          break;
        case EPreventionHeatStage.Heat_3:
          heatData = this.m_preventionPreset.Heat3();
          break;
        case EPreventionHeatStage.Heat_4:
          heatData = this.m_preventionPreset.Heat4();
		  this.maxtacSpawned = true;
          break;
      };
	  

	vehicleCount = TweakDBInterface.GetInt(heatData.GetID() + t".vehicleCount", 1);
	let i: Int32 = 0;
	while i< vehicleCount{
		
		this.SpawnPoliceVehicleWithDelay(heatStage, 7);
		i = i + 1;
	};

	this.SpawnPoliceWithDelay(heatStage, 8); 
	
  }

@addField(VehicleObject)
let preventionVehicle: Bool;

@replaceMethod(PreventionSystem)
  private final func IsVehicleValid(vehicle: wref<VehicleObject>, out slotName: CName) -> Bool {
    if !IsDefined(vehicle) {
      return false;
    };
    if vehicle.IsPlayerMounted() { //Stop them from spawning in player vehicle lmao
      return false;
    };

    if vehicle.IsDestroyed() {

      return false;
    };

	let seats: array<wref<VehicleSeat_Record>>;
	VehicleComponent.GetSeats(this.m_player.GetGame(),vehicle, seats);
    if VehicleComponent.GetNumberOfOccupiedSlots(vehicle.GetGame(), vehicle) >= ArraySize(seats)  {

      return false;
    };
	
    if VehicleComponent.GetNumberOfOccupiedSlots(vehicle.GetGame(), vehicle) == 0 && vehicle.preventionVehicle { //Check if the vehicle was used at one point and then discarded
      return false;
    };
    if !VehicleComponent.GetFirstAvailableSlot(vehicle.GetGame(), vehicle, slotName) {

      return false;
    };
	
	//Teleport vehicle to fix spawning issue
	
	if !vehicle.preventionVehicle {
		let spawnAngle: EulerAngles;
		spawnAngle.Roll = 0;
		spawnAngle.Pitch = 0;
		spawnAngle.Yaw = 0;
		GameInstance.GetTeleportationFacility(this.GetGameInstance()).Teleport(vehicle, vehicle.GetWorldPosition(), spawnAngle);
		


	};
	vehicle.preventionVehicle = true;
	
    return true;
  }


